﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Student_CompetencePart_Solution : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Student_CompetencePart_Solution, BO.Student_CompetencePart_Solution>
    {

        internal Student_CompetencePart_Solution(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Student_CompetencePart_Solution(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Student_CompetencePart_Solution.DBD) { }

        internal bool Remove(BO.Student_CompetencePart_Solution.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_CompetencePart_Solution.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsReset"].Value = Search.IsReset;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }

        internal List<BO.Student_CompetencePart_Solution> Restore(BO.Student_CompetencePart_Solution.Search Search)
        {
            return InternalRestoreList((int)DBD.Student_CompetencePart_Solution.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsReset"].Value = Search.IsReset;
            });
        }

        internal BO.Student_CompetencePart_Solution RestoreTopOne(BO.Student_CompetencePart_Solution.Search Search)
        {
            return InternalRestoreOne((int)DBD.Student_CompetencePart_Solution.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsReset"].Value = Search.IsReset;
            });
        }

        internal int Count(BO.Student_CompetencePart_Solution.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_CompetencePart_Solution.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["StudentID"].Value = Search.StudentID;
                    Command["CompetenceID"].Value = Search.CompetenceID;
                    Command["CompetencePartID"].Value = Search.CompetencePartID;
                    Command["IsReset"].Value = Search.IsReset;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }
    }
}
